package rahmawati.paerah.jaluralternatif;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.SimpleAdapter;
import android.widget.TextView;
import android.widget.Toast;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;

public class Listmacet extends AppCompatActivity {

	ConnectionDetector cd;
	Boolean isInternetPresent = false;
	AlertDialogManager alert = new AlertDialogManager();

	ProgressDialog pDialog;
	String status = "1";

	JSONArray college = null;
	ListView lve;
	Data_Jalur datajalur;
	String lati,longi;
	CONFIG_URL ip;
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		// TODO Auto-generated method stub
		super.onCreate(savedInstanceState);
		setContentView(R.layout.listmacet);
		lve = (ListView) findViewById(R.id.list);

		cekInternet();

		lve.setOnItemClickListener(new OnItemClickListener() {

			@Override
			public void onItemClick(AdapterView<?> arg0, View view,
									int position, long id) {
				// TODO Auto-generated method stub

				String nama = ((TextView) view.findViewById(R.id.nama))
						.getText().toString();
				String alamat = ((TextView) view.findViewById(R.id.alamat))
						.getText().toString();
                 lati = ((TextView) view.findViewById(R.id.latitude))
                        .getText().toString();
                 longi = ((TextView) view.findViewById(R.id.longitude))
                        .getText().toString();

				Intent x = new Intent(getApplicationContext(), Detail.class);
				x.putExtra("nama", nama);
				x.putExtra("alamat", alamat);
				x.putExtra("lat", lati );
				x.putExtra("long", longi );
				startActivity(x);
			}
		});
	}
	public void onBackPressed() {
		Intent imap= new Intent(this, menu_utama.class);
		startActivity(imap);
		finish();
	}
	public class AmbilData extends AsyncTask<String, String, String> {

		ArrayList<HashMap<String, String>> dataList = new ArrayList<HashMap<String, String>>();

		@Override
		protected void onPreExecute() {
			super.onPreExecute();
			pDialog = new ProgressDialog(Listmacet.this);
			pDialog.setMessage("Loading Data ...");
			pDialog.setIndeterminate(false);
			pDialog.setCancelable(true);
			pDialog.show();
            Log.e("rahma", "onPreExecute: ");
        }

		@Override
		protected String doInBackground(String... arg0) {
			// TODO Auto-generated method stub
			String url;
			ip = new CONFIG_URL();
			url =ip.getUrljalur();

			JSONParser jParser = new JSONParser();
			JSONObject json = jParser.getJSONFromUrl(url);
			try {
				college = json.getJSONArray("jalur");

				String success = json.getString("success");
				Log.e("rahma", "doInBackground: " + college);
				if (success.equals("1")) {

					for (int i = 0; i < college.length(); i++) {
						JSONObject c = college.getJSONObject(i);
						HashMap<String, String> map = new HashMap<String, String>();

						String id = c.getString("id").trim();
						 lati = c.getString("lati");
						 longi = c.getString("longi");
						String nama = c.getString("nama");


                        Log.e("rahma", "doInBackground: " + lati);

						map.put("id", id);
						map.put("nama", nama);
						map.put("lat", lati);
						map.put("long", longi);
						dataList.add(map);
						Log.e("rahma", "doInBackground: " + dataList);

					}
				} else {

					pDialog.dismiss();
					status = "0";

				}

			} catch (JSONException e) {

				pDialog.dismiss();

			}

			return null;
		}

		@Override
		protected void onPostExecute(String result) {
			// TODO Auto-generated method stub
			super.onPostExecute(result);

            Log.e("rahma", "onPostExecute: " + result );
            pDialog.dismiss();
			if (status.equals("0")) {
				Toast.makeText(getApplicationContext(), "data tidak ada",
						Toast.LENGTH_SHORT).show();

			}

			ListAdapter adapter = new SimpleAdapter(getApplicationContext(),
					dataList, R.layout.list_item, new String[] { "nama", "id",
							"lat", "long"},
					new int[] { R.id.nama, R.id.id, R.id.latitude,
							R.id.longitude});

			lve.setAdapter(adapter);



		}

	}

	public void cekInternet() {
		cd = new ConnectionDetector(getApplicationContext());
		isInternetPresent = cd.isConnectingToInternet();

		if (isInternetPresent) {

			new AmbilData().execute();

		} else {

			alert.showAlertDialog(Listmacet.this, "Peringatan",
					"cek koneksi internet.",
					false);
		}
	}

	/*private void parseJSON(String json){
		try {
			JSONObject jsonObject = new JSONObject(json);
			JSONArray array = jsonObject.getJSONArray("dealer");

			datadeal = new Data_Dealer(array.length());

			for(int i=0; i<array.length(); i++){
				JSONObject j = array.getJSONObject(i);

				datadeal.id[i] = getid(j);
                datadeal.nama[i] = getNama(j);
                datadeal.alamat[i] = getalamat(j);
                datadeal.asallat[i] = getlat(j);
                datadeal.asallong[i] = getlong(j);

			}

		} catch (JSONException e) {
			e.printStackTrace();
		}


	}

    private String getalamat(JSONObject j) {
        String name = null;
        try {
            name = j.getString("alamat");
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return name;
    }

    private String getlong(JSONObject j) {
        String name = null;
        try {
            name = j.getString("long");
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return name;
    }

    private String getlat(JSONObject j) {
        String name = null;
        try {
            name = j.getString("lat");
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return name;
    }



    private String getid(JSONObject j) {
        String name = null;
        try {
            name = j.getString("id");
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return name;
    }

    private String getNama(JSONObject j) {
		String name = null;
		try {
			name = j.getString("nama");
		} catch (JSONException e) {
			e.printStackTrace();
		}
		return name;
	}*/

}
